
markup.push({

    
RecordingSpinner:
{
    nsClass: "GXDrawView",
    gxHideOnNilValue: true,
    gxAnimationDivider: 2,
    gxForePainter: "RecordingSpinnerPainter",
	gxTransition: {
		nsClass: "GXSpinnerTransition",
		gxDuration: 1.0,
		gxRunOn: 1.0,
	},
},

RecordingSpinnerPainter:   // caar painter!
{
    nsClass: "GXCaarPainter",
    gxDuration: 1.0,
	gxAsset: "stopped",
	gxTintColor: "ForeColor2.noLightMode",
	lightMode: {
		ready: {
			gxTintColor: "ColorTheme1.dimmed",
			gxAsset: "ready",
			gxEdgeInsets: "2, 2, 2, 2",
		},
	},
	ready: {
		gxTintColor: "ColorTheme1",
		gxAsset: "ready",
		gxEdgeInsets: "2, 2, 2, 2",
	},
	running: {
		gxTintColor: "ColorLive1",
		gxAsset: "running",
		gxAssetDuration: 2.0,
		gxLoopStart: 1.0,
		gxPlaybackSpeed: 0.75,
    },
    transcribing: {
        gxTintColor: "ColorLive1",
        gxAsset: "transcribing",
        gxAssetDuration: 2.5,
        gxLoopStart: 0.0,
        gxEdgeInsets: "2, 2, 2, 2",
    },
    recording: {
        gxTintColor: "RecordingColor",
		gxAsset: "recording",
		gxAssetDuration: 2.0,
		gxLoopStart: 1.0,
		gxPlaybackSpeed: 0.5,
    },
    broadcasting: {
        gxTintColor: "ColorLive1",
		gxAsset: "broadcasting",
		gxAssetDuration: 2.0,
		gxLoopStart: 1.0,
		gxPlaybackSpeed: 0.75,
    },
	paused: {
		gxTintColor: "ColorLive1",
		gxEdgeInsets: "2, 2, 2, 2",
		gxAsset: "pause",
		gxAssetDuration: 3.0,
		gxLoopStart: 1.0,
		//gxLoopStart: 0.25,
		gxPlaybackSpeed: 1.25,
	},
    gxHAlign: 0.5,
    gxVAlign: 0.5,
},

    
// MARK: audio file view

// one for each recording
RecordedFileView:
{
	nsClass: "GXListItemView",
	//gxFrameRect: "10, 80, 294, 60",
    gxViewName: "audioFile",   
	gxFaceModel: {
		nsClass: "AH4AudioFileViewModel",
		gxFaceModelKeyPath: "faceModel",
	},
	gxSelectable: 2, // multiselect
	gxMenuItemsKeyPath: "sessionRecbinContextMenuItems",
	gxIntrinsicWidth: 294,
	gxIntrinsicHeight: 60,
	axIsIgnored: false,
	axRoleDescription: "Recorded File",
	axTitleKeyPath: "displayName",
	axDescriptionKeyPath: "accessibilityDescription",
	axHelp: "VO press to open an Inspector window",
	gxBackPainter: "ListItemBack",
	gxLateLayout:
	[
		"V:|-(-999)-[self(60)]",		// vertical position set by parent
		"H:|-10-[self(294)]",
		
		// views within each recording were switched to use frame rects
		// instead of auto-layout, because auto-layout failed and froze app
		// when above ~300 recordings.
		// Since then, New list view only creates enough views for display,
		// auto-layout may be fine to revert to.
		
//		"V:[self(60)]",
//
//		"H:|-0-[title]-8-|",
//		"V:|-7-[title(20)]-5-[fileTime]",
//
//		"H:|-8-[spinner(21)]-5-[recordingFormat]",
//		"V:[title]-2-[spinner(21)]",
//
//		"H:[recordingFormat(110)]-8-[fileSize]-8-[fileTime(50)]-0-|&alignBaseline",
//
//		"H:|-7-[playBtn(17)]-5-[waveForm]-0-[fileTime]&alignCenterY",
//		"V:[waveForm(28)]",
	],
	gxChildViews:
	{
		spinnerHost:
		{
			nsClass: "GXLayerHostingView",
			gxFrameRect: "8, 30, 21, 21",
			gxShowOnKey: "isRecording",
			gxRootLayer:
			{
				nsClass: "GXCaarLayer",
				gxViewName: "spinner",
				gxAnimateOnKey: "isRecording",
				gxShowOnKey: "isRecording",
				gxAnimationDivider: 2,
				gxCaarPainter: "RecordingSpinnerPainter",
				gxTransition: {
					nsClass: "GXSpinnerTransition",
					gxDuration: 1.0,
					gxRunOn: 1.0,
				},
			}
		},
		title: {
			"+": "LabelView.top",
			gxFrameRect: "0, 7, 286, 20",
			gxValueKey: "displayName",
            axTitle: "File Title",
			gxForePainter:
			{
				"+": "LabelFore.foreColor1.left.size13.mediumWeight",
				gxEdgeInsets: "10, 0, 10, 0",
			},
		},
        fileSize: {
            "+": "LabelView.centerx.colorThemeLive1.size12",
			gxFrameRect: "152, 32, 84, 17",
            gxValueKey: "fileSize",
            gxAnimateOnKey: "isRecording",
            gxShowOnKey: "isRecording",
            axTitle: "File Size",
            gxFormatter: { nsClass: "PTFileSizeFormatter" }
        },
		elapsedTime: {
			"+": "LabelView.centerx.withLive.size12",
			//gxBackPainter: fillPainter("BlackColor"),
			gxFrameRect: "23, 32, 55, 17",
			gxAnimateOnKey: "isPlaying",
			axIsIgnored: false,
			axTitle: "Elapsed Time",
			gxFormatter: {
				nsClass: "GXTimeFormatter",
				gxLeftPadString: "\u2007\u2007\u2007\u2007\u2007",
			},
		},
		displayTime: {
			"+": "LabelView.centerx.withLive.size12",
			//gxBackPainter: fillPainter("BlackColor"),
			gxFrameRect: "225, 32, 62, 17",
            axIsIgnored: false,
            axTitle: "File Duration or Remaining Time",
			gxFormatter: {
				nsClass: "GXTimeFormatter",
				gxLeftPadForSign: true,
				gxLeftPadString: "\u2007\u2007\u2007\u2007\u2007\u2007",
			},
		},
		displayTimeBtn: {
			nsClass: "GXButtonView",
			gxFrameRect: "225, 32, 62, 17",
			axTitle: "Toggle Duration/Elapsed",
		},
		recordingFormat: {
			"+": "LabelView.left.mediumWeight.colorThemeLive1.size13",
			gxFrameRect: "34, 32, 110, 17",
			gxShowOnKey: "isRecording",
			gxToolTipKeyPath: "fullDescription"
		},
		playBtn: {
			nsClass: "GXButtonView",
			gxFrameRect: "7, 30, 16, 22",
			gxBackPainter: "ImagePainter.foreColor1.playbtn",
			gxValueKey: "filePlayBtn",
			gxLayerZPosition: 10,
            gxButtonType: "toggle",
			axTitle: "play or pause",
			gxDisableOnKey: "isRecording",
		},
		waveForm: {
            nsClass: "GXWaveView",
			gxFrameRect: "79, 27, 142, 28",	  // width must match child GXWaveLayer!
			gxValueKey: "playPosition",
            gxActiveWhenSelected: true,
			gxAnimateOnKey: "isPlaying",
            gxRootLayer:
            {
                nsClass: "GXDrawLayer",
                gxLayerZPosition: 2,
                gxSublayers:
                {
                    fullWave: {
                        nsClass: "GXWaveLayer",
                        gxLayerZPosition: 4,
                        gxValueKey: "waveData",
						gxFrameRect: "0, 0, 142, 28",		// width must match parent GXWaveView!
                        gxNeedsDisplayOnResize: true,
                        gxPainter: {    // only provides colors
                            nsClass: "GXPainter",
                            gxFillColor: "ForeColor1",
                        },
                    },
                    playhead: {
                        // playhead is a puppet created for GXWaveView to use
                        nsClass: "GXDrawLayer",
						gxFrameRect: "0, 0, 2, 28",
                        gxLayerZPosition: 10,
                        gxBackPainter: {    // only used for colors
                            nsClass: "GXPainter",
                            gxCornerRadius: 1,
                            gxBackColor: "ColorThemeLive1",
                            //selected: { gxBackColor: "ForeColor2", }
                        },
                    },
                }
            }
		},
	}
},


})
